#define F_CPU 16000000UL
#define UART_BAUD 9600
#define BAUD 9600

#include <util/setbaud.h>

#include <stdint.h>
#include <stdio.h>

#include <avr/io.h>
  
void uart_init(void) {

	#if F_CPU < 2000000UL && defined(U2X)
		/* improve baud rate error by using 2x clk */
  	   UCSR0A = _BV(U2X);             
	   UCSR1A = _BV(U2X);


       UBRR0L = (F_CPU / (8UL * UART_BAUD)) - 1;
	   UBRR1L = (F_CPU / (8UL * UART_BAUD)) - 1; 

	#else
 	   UBRR0L = (F_CPU / (16UL * UART_BAUD)) - 1;
	   UBRR1L = (F_CPU / (16UL * UART_BAUD)) - 1;
	#endif

    UBRR0H = UBRRH_VALUE;
    UBRR0L = UBRRL_VALUE;
	UBRR1H = UBRRH_VALUE;
    UBRR1L = UBRRL_VALUE;

	 /* 8-bit data */ 
    UCSR0C = _BV(UCSZ01) | _BV(UCSZ00);
	UCSR1C = _BV(UCSZ11) | _BV(UCSZ10); /* 8-bit data */ 

	/* Enable RX and TX, RX interrupt */
    UCSR0B = _BV(RXEN0) | _BV(TXEN0) | _BV(RXCIE0);   
    UCSR1B = _BV(RXEN1) | _BV(TXEN1) | _BV(RXCIE1); 




}

//UART 0
void uart_putchar0(char c) {
    loop_until_bit_is_set(UCSR0A, UDRE0); /* Wait until data register empty. */
    UDR0 = c;
}


char uart_getchar0(void) {
    loop_until_bit_is_set(UCSR0A, RXC0); /* Wait until data exists. */
    return UDR0;
}

//UART 1
void uart_putchar1(char c) {
    loop_until_bit_is_set(UCSR1A, UDRE1); /* Wait until data register empty. */
    UDR1 = c;
}


char uart_getchar1(void) {
    loop_until_bit_is_set(UCSR1A, RXC1); /* Wait until data exists. */
    return UDR1;
}
