// yamb yet another music box
#include <stdio.h>
#include <math.h>

#include "wavetable.h"
#include "sustain.h"
#include "tune.h"

#define SAMPLERATE 31250
#define ENVELOPEDURATION 1500 // miliseconds
#define OSCILLATOR_COUNT 16 // number of simultaneous notes, 256 max or 8 bit accumulation will overflow 16 bits
#define SIMULTANEOUS_NOTES 8
#define CLIP 127

#define BPM 190 // beats per minute
#define QUARTER 120 // note resolution in midi file

int main(int argc, char **argv)
{
    double increments[ OSCILLATOR_COUNT ];
    double phase_accu[ OSCILLATOR_COUNT ];
	double facteur = pow (2, 1.0/12);
	double scale_table[144];
	// build scales
	int i;
	scale_table[9]=13.75; // A0
	for (i=10; i<144; i++)
		scale_table[i]=facteur*scale_table[i-1];
	for (i=8; i>0; i--)
		scale_table[i]=scale_table[i+1]/facteur;
		
    uint32_t envelope_positions[ OSCILLATOR_COUNT ]; // same
	uint8_t sustaining[ OSCILLATOR_COUNT ];  // true if the attack is finished and the channel is now using the sustain wavetable
	uint8_t playing [ OSCILLATOR_COUNT ];    // true if the channel is playing, playing stops when the sound has faded because of the envelope
	
    uint8_t next_osc = 0; // the next free (or not) channel
    uint16_t ticks = 0; // each tick we compute a sample
    uint16_t time = 0;  // tune time
    uint16_t event_index = 0; // index in the tune
	
    const uint16_t event_count = sizeof(times) / sizeof( times[ 0 ] );
    const uint32_t sizeof_wt = sizeof( wt_attack );
    const uint32_t sizeof_wt_sustain = sizeof( wt_sustain );
    double sizeof_envelope_table = SAMPLERATE;
	sizeof_envelope_table *= ENVELOPEDURATION;
	sizeof_envelope_table /= 1000.0;
	fprintf (stderr, "sizeof_envelope_table : %f\n", sizeof_envelope_table);
	
	const float sustainfreq = SAMPLERATE / sizeof_wt_sustain;
	const uint32_t TICKS_LIMIT = SAMPLERATE * 60 / (BPM * QUARTER); // ticks in a time unit of the tune
	
	// initialization, set everything to 0
	uint8_t osc;
    for ( osc = 0; osc < OSCILLATOR_COUNT; ++osc ) {
        increments[ osc ] = 0;
        phase_accu[ osc ] = 0;
        envelope_positions[ osc ] = 0;
		sustaining[ osc ] = 0;
		playing [ osc ] = 0;
    }
    while ( 1 ) {
        while ( time >= times[ event_index ] ) { // time reached the next note(s), let's assign an oscillator to it(them)
			// base sample frequency = SAMPLERATE / sizeof_wt_sustain
			// increment = note frequency / base frequency
            increments[ next_osc ] = scale_table[ pitches[ event_index ] +12 ] / sustainfreq;
            phase_accu[ next_osc ] = 0;
            envelope_positions[ next_osc ] = 0;
			sustaining [ next_osc ] = 0;
			playing [ next_osc ] = 1;
            ++next_osc;
            if ( next_osc >= OSCILLATOR_COUNT ) {
                next_osc = 0;
            }
            ++event_index;
			// if end of the song, restart
            if ( event_index >= event_count ) {
                ticks = 0;
                time = 0;
                event_index = 0;
				// remove this to loop endlessly
				return 0;
            }
        }
        ++ticks;
        if ( ticks >= TICKS_LIMIT ) {
			ticks=0;
            time += 1;
        }

        double value = 0.0;
        for ( osc = 0; osc < OSCILLATOR_COUNT; ++osc ) {
			if (playing [ osc ] ) {
				
				phase_accu[ osc ] += increments[ osc ]; // advance phase
				if (sustaining [ osc]) { // if sustaining
					if ( envelope_positions[ osc ] >= sizeof_envelope_table) {
						// sound has decayed, no need to play it anymore.
						playing [ osc ] = 0;
					} else {
						value += exp(-10.0*envelope_positions[ osc ]/(3*sizeof_envelope_table)) * 127.0*sin (phase_accu[osc]*2*M_PI/804); // apply envelope only if sustaining
						envelope_positions [ osc ] ++;
					}
				} else {
					if ( (phase_accu[ osc ] ) >= sizeof_wt ) { // check if beyond table
						sustaining [ osc ] = 1;
						phase_accu[ osc ] -= sizeof_wt ;
						value += 127.0*sin (phase_accu[osc]*2*M_PI/804);
					} else {
						value += wt_attack[ (int)phase_accu[ osc ] ];
					}
				}			
			}
        }
		value /= SIMULTANEOUS_NOTES;
		int16_t intvalue = (int) value;
        if ( intvalue > CLIP ) {
            intvalue = CLIP;
        } else if ( value < -CLIP ) {
            intvalue = -CLIP;
        }
		fputc (intvalue+128, stdout);
    }

    return 0;
}
