//#include <msp430.h>
#include <msp430g2452.h>
#include <stdint.h>

#define NBSAMPLES 4064000

volatile char nboverflow=0;
volatile unsigned char playingsample=128;

void selectChip() {
	P2OUT &= ~BIT7;
}

void deselectChip() {
	P2OUT |= BIT7;
}

char SPI_busy() {
	if (USICTL1 & USIIFG)
		return 0;
	return 1;
}

unsigned char transfer(unsigned char data) {
	char a = SPI_busy();
	USISRL = data;
	USICNT = 8;
	a = SPI_busy();
	while (a!=0)
		a=SPI_busy();
	return USISRL;
}

void readChipSignature() {
	  selectChip();
	  transfer(0x9f);
//	  Serial.print("Manufacturer ID:");
	  playingsample = transfer(0);
//	  Serial.print("Device ID 1:");
	  playingsample = transfer(0);
//	  Serial.print("Device ID 2:");
	  playingsample = transfer(0);
//	  Serial.print("Extended device information string length:");
	  playingsample = transfer(0);
	  deselectChip();

}

// chip must be selected/deselected outside to allow continuous reads
unsigned char startReading() {
  transfer(0x03);
  transfer(0); // start at address 0
  transfer(0);
  transfer(0);
  return transfer(0);
}

unsigned char nextByte() {
  return transfer(0);
}

// configure timer to generate pwm on P1.2
void setup() {
	/* Disable the watchdog. The watchdog is on by default on an MSP430, if we do not disable it it will reset the CPU after
	* 32k cycles in the standard configuration.	*/
	WDTCTL = WDTPW + WDTHOLD;
	// set P1.2 as output, P1.7 as input and P2.6 as output (and set other unused pins as outputs)
	P1DIR = 255-BIT7;
	P2OUT = 255;
	P2DIR = 255;
	P2SEL = 0; // make sure P2.6 is an output instead of XOUT
	//P3DIR = 255;

	TACCTL1	= OUTMOD_7;            // TACCR1 reset/set
	TACTL	= TASSEL_2 + MC_1;     // SMCLK, up mode
	TACCTL0 = CCIE;					// compare interrupt enabled
	TACCR0	= 255;        			// PWM Period
	TACCR1	= 128;            		// PWM Duty Cycle
	P1SEL |= BIT2;				// P1.2 = TA0.1 output

	  USICTL0 = USIPE7 +  USIPE6 + USIPE5 + USIMST + USIGE + USIOE + USISWRST; // Port, SPI master
	  USICTL1 =0;                     // Disable interrupt
	  USICKCTL = USIDIV_0 + USISSEL_2;      // /1 SMCLK
	  USICTL0 &= ~USISWRST;                 // USI released for operation

    DCOCTL = CALDCO_16MHZ;		// SET clock to 16MHz
    BCSCTL1 = CALBC1_16MHZ;
    _BIS_SR(GIE);				// enable interrupts
}

//  ======== TIMERA Interrupt Service Routine ========
#pragma vector=TIMER0_A0_VECTOR
__interrupt void TA0_ISR(void)
{
	// is called every pwm period, 1/62500 s (16 microseconds)
	TACCR1 = playingsample;
	nboverflow++;
}

int main() {
	setup();
	unsigned char sample;
	long i;

//	readChipSignature();

    while ( 1 ) {
    	// select SPI CHIP
    	selectChip();
    	// get first sample
    	playingsample = startReading();

    	for (i=1; i<NBSAMPLES; i++) {
    		// read a sample
    		sample = nextByte();

    		// wait until the sample has been played 2 Timer cycles
    		while (nboverflow<2);
    		playingsample = sample;
    		nboverflow=0;
    	}
    	// deselect SPI CHIP
    	deselectChip();
    }
}
